/////////////////////////////////////////////////////
//	Blowfish DLL Version 1.37
//  Borland C++ builder 3 Wrapper Control Ver. 1.2
//  By Kwok Ho Yin  1998,1999
////////////////////////////////////////////////////

//---------------------------------------------------------------------------
#ifndef BlowfishH
#define BlowfishH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
//---------------------------------------------------------------------------

#define	ERROR_FREE									0
#define KEY_TOO_LONG								1
#define NOT_ENOUGH_MEMORY							2
#define BAD_SOURCE									3
#define BAD_SIZE									4
#define NOT_LOCK_SOURCE								5
#define DO_NOT_SUPPORT_FOR_UNREGISTERED_VERSION		6
#define NOT_SUPPORT_PREVIOUS_VERSION				7
#define BAD_CRC										8
#define Cannot_Setup_Compressor						9
#define COMPRESS_ERROR								10
#define Cannot_Setup_Decompressor					11
#define DECOMPRESS_ERROR							12
#define DO_NOT_SUPPORT_DECOMPRESSION				13
#define	BAD_BLOCK_RECORD							14
#define BAD_PROCESS_BLOCK							15
#define NOT_ENOUGH_DATA								16
#define	CANNOT_OPEN_FILE							17
#define CANNOT_CREATE_FILE							18

#define	BF_SB_BEGIN									0
#define BF_SB_MID									1
#define BF_SB_END									2

#define ENCRYPT_COMPLETED							0
#define	DECRYPT_COMPLETED							1

//---------------------------------------------------------------------------
typedef BOOL (CALLBACK* CALLBACKFUNCPTR)(char status, DWORD TotalData);

class PACKAGE TBlowfish : public TComponent
{
private:
    HINSTANCE   DLLHandle;
    bool        CrcCheckerFlag;
    bool        CompressFlag;
    bool        ErrLogFlag;

    unsigned int   FMajor, FMinor, FExtra, FSpecial;

    unsigned int   __fastcall FWriteMajor(unsigned int Major);
    unsigned int   __fastcall FWriteMinor(unsigned int Minor);
    unsigned int   __fastcall FWriteExtra(unsigned int Extra);
    unsigned int   __fastcall FWriteSpecial(unsigned int Special);
    bool __fastcall FWriteCrc_Check(bool flag);
    bool __fastcall FWriteCompression(bool flag);
    bool __fastcall FWriteErrorLogFile(bool flag);

protected:
    AnsiString	BlowfishKey;

public:
    UINT GetErrorCode(void);
    BOOL InitializeKey(void);

	BYTE* Auto_Encipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    BYTE* Auto_Decipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    BYTE* Auto_Decipher_Text(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    BYTE* Encipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    BYTE* Decipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    BYTE* Decipher_Text(BYTE *SourcePtr, UINT InSize, UINT *OutSize);
    void Free_ResultBuffer(BYTE *Ptr);
    BYTE* CreateProcessBlock(void);
    void FreeProcessBlock(BYTE *ProcessBlockPtr);
    BYTE* Encipher_SmallBlock(BYTE *SourcePtr, UINT InSize, UINT *OutSize, BYTE *FirstSmallBlockPtr, BYTE *ProcessRecordPtr, char flag);
    BYTE* Decipher_SmallBlock(BYTE *SourcePtr, UINT InSize, UINT *OutSize, BYTE *ProcessRecordPtr, char flag);
    BOOL Encipher_File(const char *inputfilename, const char *outputfilename, DWORD *OutSize);
    BOOL Decipher_File(const char *inputfilename, const char *outputfilename, DWORD *OutSize);
    void GetErrorString(char *String);
    void SetCallbackFunc(CALLBACKFUNCPTR Funcptr);
    
    __fastcall TBlowfish(TComponent* Owner);
    __fastcall ~TBlowfish();

__published:
    __property unsigned int Major = {read=FMajor, write=FWriteMajor};
    __property unsigned int Minor = {read=FMinor, write=FWriteMinor};
    __property unsigned int Extra = {read=FExtra, write=FWriteExtra};
    __property unsigned int Special = {read=FSpecial, write=FWriteSpecial};
	__property AnsiString Key = {read=BlowfishKey, write=BlowfishKey};
    __property bool       Crc_Check = {read=CrcCheckerFlag, write=FWriteCrc_Check};
    __property bool       Compression = {read=CompressFlag, write=FWriteCompression};
    __property bool       ErrorLogFile = {read=ErrLogFlag, write=FWriteErrorLogFile};
};
//---------------------------------------------------------------------------
#endif
